import timm

# https://huggingface.co/docs/timm/en/index

import timm
pretrained_models = timm.list_models(pretrained=True)
print(len(pretrained_models))
print(pretrained_models)

vit_models = timm.list_models('*vit*', pretrained=True)
print(vit_models)

import torchinfo

# Vytvoření modelu
model = timm.create_model('vit_tiny_patch16_224', pretrained=True)

# Standardní vstupní rozměr pro tento model
# (batch_size, kanály, výška, šířka)
input_size = (1, 3, 224, 224)

# Vygenerování a tisk souhrnu
torchinfo.summary(model, input_size=input_size)
