# pip install torch-summary
import torch
import torch.nn as nn
from torchsummary import summary

class MiniCNN(nn.Module):
    def __init__(self, bias=True):
        super().__init__()
        # Cin=3, Cout=16, kernel=3x3 -> param=16*(3*3*3)+(bias 16)=432+(+16) = 448 pokud bias=True
        self.conv = nn.Conv2d(in_channels=3, out_channels=16, kernel_size=3, padding=1, bias=bias)

    def forward(self, x):
        return self.conv(x)

model = MiniCNN(bias=True)  # zkuste i bias=False
summary(model, input_size=(3, 28, 28))  # Batch dim se neuvádí

